<?php
// Comprehensive test script for all API capabilities

// Configuration
$apiUrl = 'http://localhost/ota/api/web-search/api.php'; // Update this to your API endpoint

echo "Testing All API Capabilities\n";
echo "============================\n\n";

// Test 1: Performance Metrics
echo "Test 1: Performance Metrics\n";
echo "---------------------------\n";
$postData = [
    'action' => 'performance_metrics',
    'url' => 'https://httpbin.org/html'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "HTTP Status Code: $httpCode\n";
$decodedResponse = json_decode($response, true);
if ($decodedResponse !== null) {
    echo "Response (first 200 chars):\n";
    echo substr(json_encode($decodedResponse, JSON_PRETTY_PRINT), 0, 200) . "...\n";
} else {
    echo "Response:\n";
    echo $response . "\n";
}
echo "\n";

// Test 2: Workflow Execution
echo "Test 2: Workflow Execution\n";
echo "--------------------------\n";
$postData = [
    'action' => 'workflow',
    'steps' => [
        [
            'action' => 'navigate',
            'url' => 'https://httpbin.org/html'
        ],
        [
            'action' => 'extract',
            'url' => 'https://httpbin.org/html',
            'selectors' => [
                'title' => 'h1'
            ]
        ]
    ]
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 45); // Longer timeout for workflow

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "HTTP Status Code: $httpCode\n";
$decodedResponse = json_decode($response, true);
if ($decodedResponse !== null) {
    echo "Response (first 200 chars):\n";
    echo substr(json_encode($decodedResponse, JSON_PRETTY_PRINT), 0, 200) . "...\n";
} else {
    echo "Response:\n";
    echo $response . "\n";
}
echo "\n";

// Test 3: Form Submission (using a test form)
echo "Test 3: Form Submission\n";
echo "-----------------------\n";
$postData = [
    'action' => 'form_submit',
    'url' => 'https://httpbin.org/forms/post',
    'form_data' => [
        'custname' => 'John Doe',
        'custemail' => 'john@example.com',
        'size' => 'large'
    ]
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "HTTP Status Code: $httpCode\n";
$decodedResponse = json_decode($response, true);
if ($decodedResponse !== null) {
    echo "Response (first 200 chars):\n";
    echo substr(json_encode($decodedResponse, JSON_PRETTY_PRINT), 0, 200) . "...\n";
} else {
    echo "Response:\n";
    echo $response . "\n";
}
echo "\n";

// Test 4: Cookie Management
echo "Test 4: Cookie Management\n";
echo "-------------------------\n";
$postData = [
    'action' => 'cookies',
    'url' => 'https://httpbin.org/cookies/set/test_cookie/test_value',
    'operation' => 'get'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "HTTP Status Code: $httpCode\n";
$decodedResponse = json_decode($response, true);
if ($decodedResponse !== null) {
    echo "Response (first 200 chars):\n";
    echo substr(json_encode($decodedResponse, JSON_PRETTY_PRINT), 0, 200) . "...\n";
} else {
    echo "Response:\n";
    echo $response . "\n";
}
echo "\n";

// Test 5: Wait for Conditions
echo "Test 5: Wait for Conditions\n";
echo "---------------------------\n";
$postData = [
    'action' => 'wait_for',
    'url' => 'https://httpbin.org/delay/2', // This page delays for 2 seconds
    'conditions' => [
        [
            'type' => 'element_present',
            'selector' => 'h1'
        ]
    ],
    'timeout' => 10
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "HTTP Status Code: $httpCode\n";
$decodedResponse = json_decode($response, true);
if ($decodedResponse !== null) {
    echo "Response (first 200 chars):\n";
    echo substr(json_encode($decodedResponse, JSON_PRETTY_PRINT), 0, 200) . "...\n";
} else {
    echo "Response:\n";
    echo $response . "\n";
}

echo "\nAll tests completed.\n";