<?php
// Test script for the web search API

// Configuration
$apiUrl = 'http://localhost/ota/api/web-search/api.php'; // Update this to your API endpoint

// Test cases
$testQueries = [
    'current year',
    'USA news',
    'president USA',
    'weather',
    'sports'
];

echo "Testing Web Search API\n";
echo "=====================\n\n";

foreach ($testQueries as $query) {
    echo "Testing query: '$query'\n";
    echo "------------------------\n";

    // Create the URL with query parameters
    $url = $apiUrl . '?' . http_build_query([
        'q' => $query,
        'limit' => 3
    ]);

    // Initialize cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
    ]);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);

    // Execute the request
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);

    curl_close($ch);

    if ($error) {
        echo "cURL Error: $error\n\n";
        continue;
    }

    echo "HTTP Status Code: $httpCode\n";

    // Pretty print the JSON response
    $decodedResponse = json_decode($response, true);
    if ($decodedResponse !== null) {
        echo "Response:\n";
        echo json_encode($decodedResponse, JSON_PRETTY_PRINT) . "\n";
    } else {
        echo "Response:\n";
        echo $response . "\n";
    }

    echo "\n";
}

// Test POST request as well
echo "Testing POST request\n";
echo "--------------------\n";

$postData = [
    'q' => 'technology news',
    'limit' => 2
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);

curl_close($ch);

echo "HTTP Status Code: $httpCode\n";
$decodedResponse = json_decode($response, true);
if ($decodedResponse !== null) {
    echo "Response:\n";
    echo json_encode($decodedResponse, JSON_PRETTY_PRINT) . "\n";
} else {
    echo "Response:\n";
    echo $response . "\n";
}

echo "\nTest completed.\n";