<?php
// Test script for the enhanced web search API

// Configuration
$apiUrl = 'http://localhost/ota/api/web-search/api.php'; // Update this to your API endpoint

echo "Testing Enhanced Web Search API\n";
echo "==============================\n\n";

// Test 1: Search functionality
echo "Test 1: Search functionality\n";
echo "-----------------------------\n";
$searchUrl = $apiUrl . '?' . http_build_query([
    'action' => 'search',
    'q' => 'PHP programming',
    'limit' => 3
]);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $searchUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "cURL Error: $error\n\n";
} else {
    echo "HTTP Status Code: $httpCode\n";
    $decodedResponse = json_decode($response, true);
    if ($decodedResponse !== null) {
        echo "Response (first 200 chars):\n";
        echo substr(json_encode($decodedResponse, JSON_PRETTY_PRINT), 0, 200) . "...\n";
    } else {
        echo "Response:\n";
        echo $response . "\n";
    }
    echo "\n";
}

// Test 2: Visit page functionality
echo "Test 2: Visit page functionality\n";
echo "---------------------------------\n";
$visitUrl = $apiUrl . '?' . http_build_query([
    'action' => 'visit',
    'url' => 'https://httpbin.org/html'
]);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $visitUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "cURL Error: $error\n\n";
} else {
    echo "HTTP Status Code: $httpCode\n";
    $decodedResponse = json_decode($response, true);
    if ($decodedResponse !== null) {
        echo "Response (first 200 chars):\n";
        echo substr(json_encode($decodedResponse, JSON_PRETTY_PRINT), 0, 200) . "...\n";
    } else {
        echo "Response:\n";
        echo $response . "\n";
    }
    echo "\n";
}

// Test 3: Screenshot functionality
echo "Test 3: Screenshot functionality\n";
echo "----------------------------------\n";
$postData = [
    'action' => 'screenshot',
    'url' => 'https://httpbin.org/html'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "HTTP Status Code: $httpCode\n";
$decodedResponse = json_decode($response, true);
if ($decodedResponse !== null) {
    echo "Response (first 200 chars):\n";
    echo substr(json_encode($decodedResponse, JSON_PRETTY_PRINT), 0, 200) . "...\n";
} else {
    echo "Response:\n";
    echo $response . "\n";
}

echo "\nTest completed.\n";