<?php
// Test script for the new enhanced API capabilities

// Configuration
$apiUrl = 'http://localhost/ota/api/web-search/api.php'; // Update this to your API endpoint

echo "Testing New Enhanced API Capabilities\n";
echo "====================================\n\n";

// Test 1: Get Console Logs
echo "Test 1: Get Console Logs\n";
echo "------------------------\n";
$postData = [
    'action' => 'console_logs',
    'url' => 'https://httpbin.org/html'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "HTTP Status Code: $httpCode\n";
$decodedResponse = json_decode($response, true);
if ($decodedResponse !== null) {
    echo "Response (first 200 chars):\n";
    echo substr(json_encode($decodedResponse, JSON_PRETTY_PRINT), 0, 200) . "...\n";
} else {
    echo "Response:\n";
    echo $response . "\n";
}
echo "\n";

// Test 2: Execute JavaScript
echo "Test 2: Execute JavaScript\n";
echo "---------------------------\n";
$postData = [
    'action' => 'execute_js',
    'url' => 'https://httpbin.org/html',
    'javascript' => 'navigator.userAgent'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "HTTP Status Code: $httpCode\n";
$decodedResponse = json_decode($response, true);
if ($decodedResponse !== null) {
    echo "Response (first 200 chars):\n";
    echo substr(json_encode($decodedResponse, JSON_PRETTY_PRINT), 0, 200) . "...\n";
} else {
    echo "Response:\n";
    echo $response . "\n";
}
echo "\n";

// Test 3: Interact with Page Elements
echo "Test 3: Interact with Page Elements\n";
echo "------------------------------------\n";
$postData = [
    'action' => 'interact',
    'url' => 'https://httpbin.org/forms/post',
    'interactions' => [
        [
            'type' => 'get_text',
            'selector' => 'h1'
        ]
    ]
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json'
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "HTTP Status Code: $httpCode\n";
$decodedResponse = json_decode($response, true);
if ($decodedResponse !== null) {
    echo "Response (first 200 chars):\n";
    echo substr(json_encode($decodedResponse, JSON_PRETTY_PRINT), 0, 200) . "...\n";
} else {
    echo "Response:\n";
    echo $response . "\n";
}

echo "\nAll tests completed.\n";